/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.api.persistence.IGenericSection;
import frc.emul.api.persistence.IPersistenceAttachment;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.AsciiPersistenceWriter;
import frc.emul.util.BinaryPersistenceFileFilter;
import frc.emul.util.BinaryPersistenceHeader;
import frc.emul.util.BinaryPersistenceReader;
import frc.emul.util.BinaryPersistenceWriter;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.Vectrex;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManager {
    public static boolean DEBUG_WRITE = false;
    public static boolean DEBUG_READ = false;
    public static boolean DATA_COMPRESS = true;
    public static boolean DATA_DEBUG = false;
    private static final String FOLDER_QUICKSAVES = "data/saves/quick";
    private static final String FOLDER_AUTOSAVES = "data/saves/auto";
    private static final String FOLDER_USERSAVES = "data/saves/user";
    public static final String FILE_HEADER_DUMP = "coredump_";
    public static final String FILE_EXT_SAVE = ".jvesav";
    public static final String FILE_EXT_DEBUG = ".debug";
    private static final String DEFAULT_FILENAME = "unnamed";
    private final Configuration conf;

    PersistenceManager(Configuration configuration) {
        this.conf = configuration;
    }

    public FileFilter createContentFileFilter(boolean bl) {
        return bl ? BinaryPersistenceFileFilter.createDeepFilter(this.conf.getSelectedGame()) : BinaryPersistenceFileFilter.createShallowFilter();
    }

    public File getQuickSlotFile() throws PersistenceException {
        return PersistenceManager.getQuickSlotFile(this.conf.getSelectedGame());
    }

    public static File getQuickSlotFile(CfgItemGame cfgItemGame) throws PersistenceException {
        return new File(FOLDER_QUICKSAVES, PersistenceManager.formatFileName(cfgItemGame));
    }

    public File getDumpFile(String string) throws PersistenceException {
        return PersistenceManager.getDumpFile(string, this.conf.getSelectedGame());
    }

    public static File getDumpFile(String string, CfgItemGame cfgItemGame) throws PersistenceException {
        if (string == null) {
            string = FILE_HEADER_DUMP;
        }
        return new File(FOLDER_AUTOSAVES, String.valueOf(string) + PersistenceManager.formatFileName(cfgItemGame));
    }

    public File getAutoSlotFile() throws PersistenceException {
        return PersistenceManager.getAutoSlotFile(this.conf.getSelectedGame());
    }

    public static File getAutoSlotFile(CfgItemGame cfgItemGame) throws PersistenceException {
        return new File(FOLDER_AUTOSAVES, PersistenceManager.formatFileName(cfgItemGame));
    }

    public File getUserSlotFile() throws PersistenceException {
        return PersistenceManager.getUserSlotFile(this.conf.options.lastPathUserSaves, this.conf.getSelectedGame());
    }

    public static File getUserSlotFile(String string, CfgItemGame cfgItemGame) throws PersistenceException {
        if (cfgItemGame == null) {
            throw new PersistenceException("Prerequisites", "No game selection provided");
        }
        String string2 = Utils.escapeFileNamePart(cfgItemGame.getID(), DEFAULT_FILENAME);
        if (string == null) {
            string = FOLDER_USERSAVES;
        }
        return new File(string, String.valueOf(string2) + FILE_EXT_SAVE);
    }

    public static IPersistenceReader open(CfgItemGame cfgItemGame, File file) throws PersistenceException {
        return BinaryPersistenceReader.open(cfgItemGame, file);
    }

    public void load(File file) throws PersistenceException {
        PersistenceManager.load(this.conf.getSelectedGame(), file);
    }

    public static void load(CfgItemGame cfgItemGame, File file) throws PersistenceException {
        IPersistenceReader iPersistenceReader = null;
        try {
            iPersistenceReader = PersistenceManager.open(cfgItemGame, file);
            Vectrex.INSTANCE.loadPersistentState(iPersistenceReader);
        }
        catch (Throwable throwable) {
            if (iPersistenceReader != null) {
                try {
                    iPersistenceReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (iPersistenceReader != null) {
            try {
                iPersistenceReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public void store(File file, SaveType saveType) throws PersistenceException {
        PersistenceManager.store(this.conf.getSelectedGame(), file, saveType, false, null);
    }

    public void store(File file, SaveType saveType, boolean bl, List<IPersistenceAttachment> list) throws PersistenceException {
        PersistenceManager.store(this.conf.getSelectedGame(), file, saveType, bl, list);
    }

    public static void store(CfgItemGame cfgItemGame, File file, SaveType saveType) throws PersistenceException {
        PersistenceManager.store(cfgItemGame, file, saveType, false, null);
    }

    public static void store(CfgItemGame cfgItemGame, File file, SaveType saveType, boolean bl, List<IPersistenceAttachment> list) throws PersistenceException {
        IPersistenceWriter iPersistenceWriter;
        Object object;
        try {
            file.getParentFile().mkdirs();
        }
        catch (Exception exception) {
            throw new PersistenceException("File System", "Failed to create the target file folder", exception);
        }
        if (DEBUG_WRITE) {
            try {
                object = new File(String.valueOf(file.getPath()) + FILE_EXT_DEBUG);
                iPersistenceWriter = AsciiPersistenceWriter.open((File)object, false);
                PersistenceManager.storeImpl(iPersistenceWriter, bl, list);
            }
            catch (Exception exception) {
                System.err.println("*** Error while saving debug information");
                exception.printStackTrace(System.err);
            }
        }
        object = new BinaryPersistenceHeader();
        ((BinaryPersistenceHeader)object).setSaveType(saveType.ID);
        ((BinaryPersistenceHeader)object).setDebugEnabled(DATA_DEBUG);
        ((BinaryPersistenceHeader)object).setCompressed(DATA_COMPRESS);
        ((BinaryPersistenceHeader)object).setHasAttachment(list != null && !list.isEmpty());
        iPersistenceWriter = BinaryPersistenceWriter.open((BinaryPersistenceHeader)object, cfgItemGame, file);
        PersistenceManager.storeImpl(iPersistenceWriter, bl, list);
    }

    public static String isValidSaveFile(File file) {
        return null;
    }

    public String isMatchingSaveFile(File file) {
        return null;
    }

    public static List<IPersistenceAttachment> loadAttachments(IPersistenceReader iPersistenceReader, boolean bl) throws PersistenceException {
        if (bl) {
            iPersistenceReader.fetchSection((IPersistentSection)PersistentSection.ATTACHMENTS);
        } else {
            iPersistenceReader.openSection(PersistentSection.ATTACHMENTS);
        }
        ArrayList<IPersistenceAttachment> arrayList = new ArrayList<IPersistenceAttachment>();
        int n = iPersistenceReader.readU16();
        while (n-- > 0) {
            IGenericSection iGenericSection = iPersistenceReader.openSection();
            arrayList.add(new Attachment(iGenericSection, iGenericSection.getSize(), iPersistenceReader));
            iPersistenceReader.closeSection();
        }
        if (!bl) {
            iPersistenceReader.closeSection();
        }
        return arrayList;
    }

    private static void storeAttachments(IPersistenceWriter iPersistenceWriter, List<IPersistenceAttachment> list) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.ATTACHMENTS);
        iPersistenceWriter.write16(list == null ? 0 : list.size());
        if (list != null) {
            for (IPersistenceAttachment iPersistenceAttachment : list) {
                iPersistenceWriter.openSection(iPersistenceAttachment.getSection());
                iPersistenceWriter.write(iPersistenceAttachment.getContent());
                iPersistenceWriter.closeSection();
            }
        }
        iPersistenceWriter.closeSection();
    }

    private static void storeImpl(IPersistenceWriter iPersistenceWriter, boolean bl, List<IPersistenceAttachment> list) throws PersistenceException {
        try {
            Vectrex.INSTANCE.storePersistentState(iPersistenceWriter, bl);
            PersistenceManager.storeAttachments(iPersistenceWriter, list);
        }
        catch (Throwable throwable) {
            if (iPersistenceWriter != null) {
                try {
                    iPersistenceWriter.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (iPersistenceWriter != null) {
            try {
                iPersistenceWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String formatFileName(CfgItemGame cfgItemGame) throws PersistenceException {
        if (cfgItemGame == null) {
            throw new PersistenceException("Prerequisites", "No game selection provided");
        }
        return String.valueOf(cfgItemGame.info.getFilenameCandidate(DEFAULT_FILENAME, true)) + FILE_EXT_SAVE;
    }

    static class Attachment
    implements IPersistenceAttachment {
        private final IPersistentSection section;
        private final byte[] data;

        Attachment(IPersistentSection iPersistentSection, int n, IPersistenceReader iPersistenceReader) throws PersistenceException {
            this.section = iPersistentSection;
            this.data = iPersistenceReader.read(n);
        }

        public IPersistentSection getSection() {
            return this.section;
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveType {
        UNKNOWN(0),
        USER(2),
        AUTO(1),
        QUICK(3),
        DUMP(4);

        final int ID;

        private SaveType(int n2) {
            this.ID = n2;
        }
    }
}

